<?php
// =====================
// ERROR REPORTING (DEV)
// =====================
error_reporting(E_ALL);
ini_set('display_errors', 1);

// =====================
// DB CONNECTION
// =====================
include "../includes/db.php";

$status   = "";
$message  = "";
$redirect = "";

// =====================
// FORM SUBMIT
// =====================
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // Sanitize inputs
    $fullname = trim($_POST['fullname'] ?? '');
    $email    = trim($_POST['email'] ?? '');
    $mobile   = trim($_POST['mobile'] ?? '');
    $country  = trim($_POST['country'] ?? '');
    $state    = trim($_POST['state'] ?? '');
    $city     = trim($_POST['city'] ?? '');
    $pincode  = trim($_POST['pincode'] ?? '');
    $address  = trim($_POST['address'] ?? '');
    $company  = trim($_POST['company_name'] ?? '');
    $gst      = trim($_POST['gst_no'] ?? '');
    $pan      = trim($_POST['pan_no'] ?? '');
    $password = trim($_POST['password'] ?? '');
    $confirm  = trim($_POST['confirm_password'] ?? '');

    // =====================
    // BASIC VALIDATION
    // =====================
    if (
        $fullname === "" || $email === "" || $mobile === "" ||
        $country === "" || $state === "" || $city === "" ||
        $pincode === "" || $address === "" || $password === ""
    ) {
        $status = "error";
        $message = "All required fields must be filled!";
    }

    // =====================
    // PASSWORD VALIDATION
    // =====================
    elseif ($password !== $confirm) {
        $status = "error";
        $message = "Passwords do not match!";
    }
    elseif (!ctype_digit($password)) {
        $status = "error";
        $message = "Password must contain only numbers!";
    }
    elseif (strlen($password) < 5) {
        $status = "error";
        $message = "Password must be at least 5 digits long!";
    }

    // =====================
    // CHECK EMAIL EXISTS
    // =====================
    if ($status === "") {
        $check = mysqli_prepare($conn, "SELECT id FROM users WHERE email = ?");
        mysqli_stmt_bind_param($check, "s", $email);
        mysqli_stmt_execute($check);
        mysqli_stmt_store_result($check);

        if (mysqli_stmt_num_rows($check) > 0) {
            $status = "error";
            $message = "Email already registered!";
        }
    }

    // =====================
    // INSERT USER (NO HASH)
    // =====================
    if ($status === "") {

        $sql = "INSERT INTO users 
        (fullname, email, mobile, country, state, city, pincode, address, company_name, gst_no, pan_no, password)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = mysqli_prepare($conn, $sql);

        mysqli_stmt_bind_param(
            $stmt,
            "ssssssssssss",
            $fullname,
            $email,
            $mobile,
            $country,
            $state,
            $city,
            $pincode,
            $address,
            $company,
            $gst,
            $pan,
            $password
        );

        if (mysqli_stmt_execute($stmt)) {
            $status   = "success";
            $message  = "Registration successful! Redirecting to login...";
            $redirect = "userlogin.php";
        } else {
            $status = "error";
            $message = "Database error. Please try again.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>User Registration</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../assets/images/starserver/star-server-favicon.png">
    <!-- font-awesome -->
    <!-- Font Awesome 6.5.1 (FREE) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
        crossorigin="anonymous" referrerpolicy="no-referrer" />

</head>

<body>

    <div class="form_section">

        <!-- MESSAGE -->
        <?php if ($message !== "") : ?>
        <div class="alert <?= ($status === 'success') ? 'alert-success' : 'alert-error'; ?>">
            <?= $message; ?>
        </div>

        <?php if ($status === "success") : ?>
        <script>
            setTimeout(() => {
                window.location.href = "<?= $redirect ?>";
            }, 2000);
        </script>
        <?php endif; ?>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-6">
                <!-- FORM -->
                <form method="POST" class="registration-form">
                    <h2>Star Server - <span>User Registration</span></h2>

                    <div class="form-group">
                        <label>Full Name</label>
                        <input type="text" name="fullname" required>
                    </div>

                    <div class="two-column">
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" required>
                        </div>
                        <div class="form-group">
                            <label>Mobile No.</label>
                            <input type="tel" name="mobile" maxlength="10" required>
                        </div>
                    </div>

                    <div class="two-column">
                        <div class="form-group">
                            <label>Country</label>
                            <input type="text" name="country" required>
                        </div>
                        <div class="form-group">
                            <label>State</label>
                            <input type="text" name="state" required>
                        </div>
                    </div>

                    <div class="two-column">
                        <div class="form-group">
                            <label>City</label>
                            <input type="text" name="city" required>
                        </div>
                        <div class="form-group">
                            <label>Pin Code</label>
                            <input type="text" name="pincode" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Full Address</label>
                        <textarea name="address" required></textarea>
                    </div>

                    <div class="form-group">
                        <label>Company Name</label>
                        <input type="text" name="company_name">
                    </div>

                    <div class="two-column">
                        <div class="form-group">
                            <label>GST No.</label>
                            <input type="text" name="gst_no">
                        </div>
                        <div class="form-group">
                            <label>PAN No.</label>
                            <input type="text" name="pan_no">
                        </div>
                    </div>

                    <div class="two-column">
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" name="password" pattern="[0-9]{5,}"
                                title="Password must be numeric and at least 5 digits" required>
                        </div>
                        <div class="form-group">
                            <label>Confirm Password</label>
                            <input type="password" name="confirm_password" required>
                        </div>
                    </div>

                    <button type="submit">Create Account</button>

                    <p class="login-link">
                        Already have an account?
                        <a href="userlogin.php">Login here</a>
                    </p>
                </form>
            </div>

            <div class="col-md-6">
                <div class="star_col">
                    <div class="col_box">
                        <h1>STAR <span>SERVER</span></h1>
                        <h3><strong>Welcome Back to Star Server 🚀</strong>
                            Say hello to your refreshed Star Server Customer Panel.
                            Everything you need is right where you left it.
                        </h3>
                        <strong>Everything you know and trust remains the same:</strong>
                        <ul>
                            <li><i class="fa-solid fa-square-check"></i> Your login details remain the same</li>
                            <li><i class="fa-solid fa-square-check"></i> Your products and services are untouched</li>
                            <li><i class="fa-solid fa-square-check"></i> Our support team is still available 24/7</li>
                            <li><i class="fa-solid fa-square-check"></i> Your account remains safe and secure</li>
                        </ul>

                        <p><strong>What’s new:</strong></p>
                        <p>We’ve improved the layout to make things easier to find and more pleasant to use.
                            No surprises — just a smarter, cleaner design.
                        </p>

                        <h6>We’re currently importing data from our previous system. If anything doesn’t look quite
                            right yet, please bear with us. Our team is actively working to complete the transition.
                        </h6>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Font Awesome JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/js/all.min.js"
        integrity="sha512-7j7R6D8zjLxyY7G5C4M2U3kZzP4P5a6lG1YH1tPZbG7R6Y6t1jY0D6z1Z6J6xZ+X2C8b1XQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer">
    </script>


</body>


</html>