<?php
require_once "../includes/db.php";
session_start();

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $fullname = trim($_POST['name'] ?? '');
    $mobile   = trim($_POST['phone'] ?? '');
    $email    = trim($_POST['email'] ?? '');
    $address  = trim($_POST['address'] ?? '');
    $domain   = trim($_POST['domain'] ?? '');
    $plan     = trim($_POST['package'] ?? '');

    if (!$conn) {
        die("DB connection failed");
    }

    $user_id = $_SESSION['user_id'] ?? 0;
    $status  = "Pending";
    $expiry  = date('Y-m-d', strtotime('+1 year'));

    $sql = "INSERT INTO hosting_plans 
        (user_id, status, expiry_date, plan_name, domain_name, fullname, mobile, email, address)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = mysqli_prepare($conn, $sql); // ✅ FIX HERE

    if (!$stmt) {
        die("Prepare failed: " . mysqli_error($conn));
    }

    mysqli_stmt_bind_param(
        $stmt,
        "issssssss",
        $user_id,
        $status,
        $expiry,
        $plan,
        $domain,
        $fullname,
        $mobile,
        $email,
        $address
    );

    mysqli_stmt_execute($stmt);

    header("Location: payment.php");
    exit;
}
?>
