<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Star Server 20 Hosting Plans Overview – High-Speed, Secure & Scalable Hosting | Star Server</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- AOS -->
    <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="../assets/css/starstyle.css">
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../assets/image/starserver.png">
    <!-- Google or browser tab -->
    <link rel="icon" href=".././favicon.ico/assets/image/starserver.png" type="image/x-icon">

    <!-- seo -->
    <!-- Meta Description -->
    <meta name="description"
        content="Star Server offers high-speed, secure, and scalable hosting plans. Explore Star Server hosting solutions with SSD storage, LiteSpeed servers, global data centers, advanced security, 24/7 support, and effortless website management for blogs, businesses, and high-traffic websites.">


    <!-- Meta Keywords -->
    <!-- SEO Keywords (Horizontal Format) -->
    <meta name="keywords"
        content="Star Server hosting plans, Star Server hosting solutions, Star Server high-speed hosting, Star Server SSD hosting, Star Server NVMe SSD, Star Server LiteSpeed hosting, Star Server secure hosting, Star Server backup solutions, Star Server scalable hosting, Star Server 24/7 support, Star Server expert support, Star Server global data centers, Star Server fast connectivity, Star Server website control panel, Star Server easy-to-use control panel, Star Server website management, Star Server uptime guarantee, Star Server advanced security, Star Server Imunify360, Star Server hosting performance, Star Server reliable hosting, Star Server beginner-friendly hosting, Star Server hosting for blogs, Star Server hosting for businesses, Star Server hosting for enterprises, Star Server professional hosting, Star Server hosting features, Star Server hosting benefits, Star Server hosting overview, Star Server hosting comparison, Star Server hosting packages, Star Server hosting pricing, Star Server affordable hosting, Star Server low-cost hosting, Star Server hosting India, Star Server hosting for developers, Star Server hosting for agencies, Star Server hosting for resellers, Star Server hosting for portfolios, Star Server managed hosting, Star Server cloud hosting, Star Server VPS hosting, Star Server dedicated hosting, Star Server WordPress hosting, Star Server cPanel hosting, Star Server one-click WordPress, Star Server hosting tutorials, Star Server hosting guides, Star Server hosting tips, Star Server hosting tricks, Star Server beginner guide, Star Server step-by-step hosting, Star Server hosting instructions, Star Server fast website setup, Star Server website launch, Star Server reliable server, Star Server high-performance hosting, Star Server optimized servers, Star Server scalable resources, Star Server hosting reliability, Star Server hosting uptime, Star Server hosting security, Star Server hosting speed, Star Server hosting control, Star Server hosting dashboard, Star Server hosting account, Star Server hosting setup, Star Server hosting services, Star Server mission, Star Server vision, Star Server trusted hosting, Star Server innovative hosting, Star Server professional support, Star Server website growth, Star Server business hosting, Star Server enterprise hosting, Star Server hosting management, Star Server server optimization, Star Server hosting expertise, Star Server technical hosting support, Star Server website performance, Star Server hosting efficiency, Star Server hosting excellence, Star Server hosting experience, Star Server hosting innovation, Star Server hosting solutions India, Star Server hosting for startups, Star Server hosting for agencies India, Star Server hosting guide India, Star Server reliable website hosting, Star Server high-speed website hosting, Star Server cloud-based hosting, Star Server hosting for all websites, Star Server hosting reliability India">

    <style>
        .hosting_wrap {
            background: #f4f7fb;

        }

        /* MAIN WRAPPER */
        .hosting-wrapper {
            min-height: 100vh;
            display: flex;
            align-items: center;
            padding: 50px 15px;
        }

        .hosting-box {
            max-width: 1100px;
            margin: auto;
            background: #ffffff;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.08);
        }

        /* LEFT SIDE */
        .plan-side {
            background: linear-gradient(160deg, #05305e, #003772);
            color: #fff;
            padding: 40px;
            height: 100%;
        }

        .plan-side h2 {
            font-weight: 700;
            margin-bottom: 10px;
            font-size: 40px;
        }

        .plan-price {
            font-size: 30px;
            font-weight: 700;
            margin-bottom: 25px;
        }

        .plan-price span {
            font-size: 14px;
            font-weight: 400;
        }

        .plan-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .plan-list li {
            padding: 8px 0;
            font-size: 14px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
        }

        .plan-best {
            margin-top: 20px;
            /* background: rgba(255, 255, 255, 0.15); */
            padding: 12px;
            border-radius: 8px;
            font-size: 14px;
            background: #fff;
            color: blue;
        }

        /* RIGHT SIDE */
        .form-side {
            padding: 40px;
        }

        .form-side h3 {
            color: #0D427B;
            font-weight: 700;
            margin-bottom: 25px;
            text-align: center;
        }

        .form-side label {
            font-size: 14px;
            color: #0D427B;
            margin-bottom: 6px;
            display: block;
        }

        .form-side input {
            width: 100%;
            padding: 12px;
            border-radius: 6px;
            border: 1px solid #c7d4e6;
            margin-bottom: 16px;
            font-size: 14px;
        }

        .form-side input:focus {
            outline: none;
            border-color: #0D427B;
            box-shadow: 0 0 0 2px rgba(13, 66, 123, 0.15);
        }

        .form-side button {
            width: 100%;
            padding: 14px;
            background: #0D427B;
            color: #fff;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            font-size: 15px;
            cursor: pointer;
        }

        .form-side button:hover {
            background: #09335f;
        }

        /* RESPONSIVE */
        @media (max-width: 768px) {
            .plan-side {
                text-align: center;
            }
        }
    </style>
</head>

<body>

    <!-- CONTENT HERE -->
    <div class="page-wrapper">

        <!-- Top Header Start-->
        <div class="top-header">
            <marquee behavior="scroll" direction="left" scrollamount="5">
                Our Hosting Started from ₹550 (No Extra GST) With Same Renewal Price
            </marquee>
        </div>
        <!-- Top Header End-->

        <!--  Navbar-Start  -->
        <nav class="navbar navbar-expand-lg sticky-top">
            <div class="container-fluid px-lg-5" style="max-width: 1200px;">
                <a class="navbar-brand" href="../index.php">
                    <img src="../assets/image/starserver.png" alt="Star Server" style="height: 50px;">

                </a>

                <div class="collapse navbar-collapse justify-content-center" id="desktopMenu">
                    <ul class="navbar-nav side-style-nav">

                        <li class="nav-item">
                            <a class="nav-link" href="../index.php">
                                <i class="bi bi-house-door"></i>
                                <span class="link-text">Home</span>
                            </a>
                        </li>

                        <li class="nav-item custom-dropdown">
                            <a class="nav-link" href="./starserver-about.php">
                                <i class="bi bi-info-circle"></i>
                                <span class="link-text">About</span>
                            </a>
                            <!-- <div class="dropdown-pane">
                                <a href="history.php">Company History</a>
                                <a href="founder.php">Founder's Message</a>
                            </div> -->
                        </li>

                        <li class="nav-item custom-dropdown">
                            <a class="nav-link" href="../page/starserver-services.php">
                                <i class="bi bi-gear"></i>
                                <span class="link-text">Services</span>
                            </a>
                            <div class="dropdown-pane">
                                <a href="../page/starserver-single-domain-hosting.php">Single Domain Hosting</a>
                                <a href="../page/starserver-double-domain-plan.php">Double Domain Plan</a>
                                <a href="../page/starserver-five-domain-plan.php">5 Domain Plan</a>
                                <a href="../page/starserver-ten-domain-plan.php">10 Domain Plan</a>
                                <a href="../page/starserver-twenty-domains-plan.php">20 Domains Plan</a>
                                <a href="../page/starserver-unlimited-domain-plan.php"> Unlimited Domain Plan</a>
                            </div>
                        </li>

                        <li class="nav-item custom-dropdown">
                            <a class="nav-link" href="../support/starserver-support.php">
                                <i class="bi bi-headset"></i>
                                <span class="link-text">Support</span>
                            </a>
                            <div class="dropdown-pane">
                                <a href="../support/starserver-frequently-asked-questions.php">Frequently Asked
                                    Questions (FAQ)</a>
                                <a href="../support/starserver-buy-hosting.php">How to Buy Hosting</a>
                                <a href="../support/starserver-install-wordPress.php">How to Install WordPress</a>
                                <a href="../support/starserver-migrate-website.php">How to Migrate Website</a>
                                <a href="../support/starserver-hosting-comparison-table.php">Hosting Comparison
                                    Table</a>
                            </div>

                        </li>

                        <li class="nav-item custom-dropdown">
                            <a class="nav-link" href="../blog/starserver-blogs.php">
                                <i class="bi bi-journal-text"></i>
                                <span class="link-text">Blogs</span>
                            </a>
                            <div class="dropdown-pane">
                                <a href="../blog/starserver-affordable-cpanel-hosting-india.php">Affordable cPanel
                                    Hosting</a>
                                <a href="../blog/starserver-launch-website.php">Website Launch Guide</a>
                            </div>
                        </li>

                        <li class="nav-item custom-dropdown">
                            <a class="nav-link" href="../page/starserver-tools-&-add-ons.php">
                                <i class="bi bi-puzzle"></i>
                                <span class="link-text" style="font-size: 13px;">Tools & Add-ons</span>
                            </a>
                            <div class="dropdown-pane">
                                <a href="../page/starserver-website-builder.php">Website Builder (SitePad)</a>
                                <a href="../page/starserver-one-click-app-installer.php">1-Click App Installer
                                    (Softaculous)</a>
                                <a href="../page/starserver-email-hosting-&-business-email.php">Email Hosting &
                                    Business
                                    Email</a>
                                <a href="../page/starserver-dns-management.php">DNS Management</a>
                                <a href="../page/starserver-git-&-developer .php">Git & Developer Tools</a>
                            </div>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="../page/starserver-contact.php">
                                <i class="bi bi-telephone-outbound"></i>
                                <span class="link-text">Contact Us</span>
                            </a>
                        </li>
                    </ul>
                </div>

                <div class="d-none d-lg-flex">
                    <a href="https://clients.starserver.in/" class="btn btn-support">
                        <i class="bi bi-life-preserver me-2"></i>Support
                    </a>
                </div>

                <div class="d-none d-lg-flex">
                    <a href="login.php" class="btn btn-login">
                        <i class="bi bi-person-lock me-2"></i>Client Login
                    </a>
                </div>

                <button class="navbar-toggler ms-2" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>
        </nav>


        <div class="offcanvas offcanvas-start stylish-offcanvas d-lg-none" tabindex="-1" id="offcanvasNavbar">
            <div class="offcanvas-header border-bottom">
                <div class="offcanvas-title">
                    <img src="../../assets/image/starserver.png" alt="Star Server" style="height: 40px;">
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
            </div>

            <div class="offcanvas-body d-flex flex-column">
                <ul class="navbar-nav mobile-nav-list mb-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="../index.php"><i class="bi bi-house-door me-2"></i> Home</a>
                    </li>

                    <li class="nav-item dropdown-mobile">
                        <div class="d-flex justify-content-between align-items-center">
                            <a href="./starserver-about.php" class="nav-link flex-grow-1"><i
                                    class="bi bi-info-circle me-2"></i>
                                About
                                Us</a>
                            <!-- <span class="toggle-icon" data-bs-toggle="collapse" data-bs-target="#mobAbout"><i
                                    class="bi bi-plus-lg"></i></span> -->
                        </div>
                        <!-- <div class="collapse" id="mobAbout">
                            <ul class="sub-menu">
                                <li><a href="history.php">Our History</a></li>
                                <li><a href="founder.php">Founder's Message</a></li>
                            </ul>
                        </div> -->
                    </li>

                    <li class="nav-item dropdown-mobile">
                        <div class="d-flex justify-content-between align-items-center">
                            <a href="../page/starserver-services.php" class="nav-link flex-grow-1"><i
                                    class="bi bi-gear me-2"></i>
                                Services</a>
                            <span class="toggle-icon" data-bs-toggle="collapse" data-bs-target="#mobSer"><i
                                    class="bi bi-plus-lg"></i></span>
                        </div>
                        <div class="collapse" id="mobSer">
                            <ul class="sub-menu">
                                <li><a href="../page/starserver-single-domain-hosting.php">Single Domain Plan</a></li>
                                <li><a href="../page/starserver-double-domain-plan.php">Double Domain Plan</a></li>
                                <li><a href="../page/starserver-five-domain-plan.php">5 Domain Plan</a></li>
                                <li><a href="../page/starserver-ten-domain-plan.php">10 Domain Plan</a></li>
                                <li><a href="../page/starserver-twenty-domains-plan.php">20 Domains Plan</a></li>
                                <li><a href="../page/starserver-unlimited-domain-plan.php"> Unlimited Domain Plan</a>
                                </li>
                            </ul>
                        </div>
                    </li>

                    <li class="nav-item dropdown-mobile">
                        <div class="d-flex justify-content-between align-items-center">
                            <a href="../support/starserver-support.php" class="nav-link flex-grow-1"><i
                                    class="bi bi-headset me-2"></i>
                                Support</a>
                            <span class="toggle-icon" data-bs-toggle="collapse" data-bs-target="#mobSup"><i
                                    class="bi bi-plus-lg"></i></span>
                        </div>
                        <div class="collapse" id="mobSup">
                            <ul class="sub-menu">
                                <li><a href="../support/starserver-frequently-asked-questions.php">Frequently Asked
                                        Questions (FAQ)</a></li>
                                <li><a href="../support/starserver-buy-hosting.php">How to Buy Hosting</a></li>
                                <li><a href="../support/starserver-install-wordPress.php">How to Install WordPress</a>
                                </li>
                                <li><a href="../support/starserver-migrate-website.php">How to Migrate Website</a></li>
                                <li><a href="../support/starserver-hosting-comparison-table.php">Hosting Comparison
                                        Table</a></li>
                            </ul>
                        </div>
                    </li>

                    <li class="nav-item dropdown-mobile">
                        <div class="d-flex justify-content-between align-items-center">
                            <a href="../blog/starserver-blogs.php" class="nav-link flex-grow-1"><i
                                    class="bi bi-journal-text me-2"></i>
                                Blogs</a>
                            <span class="toggle-icon" data-bs-toggle="collapse" data-bs-target="#mobBlog"><i
                                    class="bi bi-plus-lg"></i></span>
                        </div>
                        <div class="collapse" id="mobBlog">
                            <ul class="sub-menu">
                                <li><a href="../blog/starserver-affordable-cpanel-hosting-india.php">Affordable cPanel
                                        Hosting</a></li>
                                <li><a href="../blog/starserver-launch-website.php">Website Launch Guide</a></li>
                            </ul>
                        </div>
                    </li>

                    <li class="nav-item dropdown-mobile">
                        <div class="d-flex justify-content-between align-items-center">
                            <a href="../page/starserver-tools-&-add-ons.php" class="nav-link flex-grow-1"><i
                                    class="bi bi-puzzle me-2"></i>
                                Tools & Add-ons</a>
                            <span class="toggle-icon" data-bs-toggle="collapse" data-bs-target="#mobTool"><i
                                    class="bi bi-plus-lg"></i></span>
                        </div>
                        <div class="collapse" id="mobTool">
                            <ul class="sub-menu">
                                <li><a href="../page/starserver-website-builder.php">Website Builder (SitePad)</a></li>
                                <li><a href="../page/starserver-one-click-app-installer.php">1-Click App Installer
                                        (Softaculous)</a></li>
                                <li><a href="../page/starserver-email-hosting-&-business-email.php">Email Hosting &
                                        Business Email</a></li>
                                <li><a href="../page/starserver-dns-management.php">DNS Management</a></li>
                                <li><a href="../page/starserver-git-&-developer .php">Git & Developer Tools</a></li>
                            </ul>
                        </div>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="../page/starserver-contact.php"><i
                                class="bi bi-telephone-outbound me-2"></i> Contact
                            Us</a>
                    </li>
                </ul>

                <a href="login.php" class="btn btn-support w-100 mt-3 login-mob-btn">Support</a>
                <a href="login.php" class="btn btn-primary w-100 mt-3 login-mob-btn">Client Login</a>

                <div class="offcanvas-footer mt-4">
                    <div class="contact-card">
                        <h6>Contact Info</h6>
                        <a href="tel:+919432807919"><i class="bi bi-telephone"></i> +91 9432807919</a>
                        <a href="mailto:info@starserver.in"><i class="bi bi-envelope"></i>
                            info@starserver.in</a>
                        <a href="mailto:helpdesk@starserver.in"><i class="bi bi-envelope"></i>
                            helpdesk@starserver.in</a>
                    </div>

                    <div class="social-links d-flex justify-content-around mt-3">
                        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-twitter-x"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-linkedin"></i></a>
                        <a href="#" class="social-icon text-success"><i class="bi bi-whatsapp"></i></a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Navbar-End -->


        <!-- breadcrumb-section-Start -->
        <section id="breadcrumb-section" class="breadcrumb-section">
            <div class="breadcrumb-container">
                <!-- Heading -->
                <h1>Star Server - 20 Domain hosting plan</h1>

                <!-- Breadcrumb as buttons (non-clickable) -->
                <nav class="breadcrumb-nav">
                    <a href="../index.php" class="breadcrumb-btn breadcrumb-link">Home</a>
                    <span class="breadcrumb-separator">/</span>
                    <span class="breadcrumb-btn current">20 Domain hosting plan</span>
                </nav>
            </div>
        </section>
        <!-- breadcrumb-section-End -->



        <div class="hosting_wrap">
            <div class="hosting-wrapper">
                <div class="hosting-box row g-0 w-100">

                    <!-- LEFT : PLAN DETAILS -->
                    <div class="col-md-6 plan-side">
                        <h2>20 Domain Plan</h2>
                        <div class="plan-price">₹ 1850 <span>/ Year</span></div>

                        <ul class="plan-list">
                            <li>Up to 20 Domains</li>
                            <li>Unlimited Email Accounts</li>
                            <li>Unlimited NVMe SSD Space</li>
                            <li>3 GB RAM</li>
                            <li>5000 MB Email Space / ID</li>
                            <li>Unlimited Bandwidth</li>
                            <li>Unlimited Subdomains</li>
                            <li>cPanel Control Panel</li>
                            <li>Free SSL Certificate</li>
                            <li>WordPress 1-Click Install</li>
                            <li>SSH / Terminal Access</li>
                            <li>Daily Backups</li>
                            <li>99.99% Uptime Guarantee</li>
                            <li>Priority Support</li>
                        </ul>

                        <div class="plan-best">
                            <strong>Best for:</strong>  Small Agencies, Growing Businesses
                        </div>
                    </div>

                    <!-- RIGHT : ORDER FORM -->
                    <div class="col-md-6 form-side">
                        <h3>Hosting Order Form</h3>

                        <form action="../user/submit_order.php" method="POST">
                            <label>Full Name</label>
                            <input type="text" name="name" required>

                            <label>Phone Number</label>
                            <input type="tel" name="phone" required>

                            <label>Email Address</label>
                            <input type="email" name="email" required>

                            <label>Domain Name</label>
                            <input type="text" name="domain" placeholder="example.com" required>

                            <input type="hidden" name="package" value="Single Domain Plan">

                            <button type="submit">Submit Order</button>
                        </form>
                    </div>

                </div>
            </div>
        </div>


        <!-- custom-code-Start -->
        <section class="custom-code">
            <div class="container">
                <div class="navigator-content">

                    <!-- Text -->
                    <h2 data-aos="fade-up" data-aos-duration="1200">
                        Design Your Website by using <span><strong>Custom Code / WordPress</strong></span>
                    </h2>

                    <!-- Buttons -->
                    <div class="navigator-actions">
                        <a href="tel:+919432807919" class="navigator-btn call-btn" data-aos="fade-left"
                            data-aos-duration="1300">
                            📞 Call Us
                        </a>

                        <a href="https://wa.me/919432807919?text=Hello!%20I%20want%20to%20know%20more%20about%20your%20website%20services."
                            class="navigator-btn whatsapp-btn" target="_blank" data-aos="fade-left"
                            data-aos-duration="1400">
                            💬 WhatsApp
                        </a>
                    </div>

                </div>
            </div>
        </section>
        <!-- custom-code-End -->



        <!-- footer -->
        <footer class="main-footer">
            <div class="footer-container">

                <!-- MAIN FOOTER CONTENT -->
                <div class="footer-main-row">

                    <!-- 1. BRAND COLUMN -->
                    <div class="footer-col brand-col">
                        <!-- <img src="../../assets/image/starserver.php" alt="Star Server" class="footer-logo"> -->
                        <img src="../assets/image/starserver.png" alt="Star Server" class="footer-logo">
                        <p class="brand-text">
                            Star Server provides continuous, secure, and scalable cloud solutions for
                            thousands of businesses worldwide.
                        </p>

                        <div class="footer-socials">
                            <a href="#"><i class="bi bi-twitter-x"></i></a>
                            <a href="#"><i class="bi bi-wordpress"></i></a>
                            <a href="#"><i class="bi bi-instagram"></i></a>
                            <a href="#"><i class="bi bi-youtube"></i></a>
                            <a href="#"><i class="bi bi-linkedin"></i></a>
                        </div>

                        <!-- <div class="review-badges">
                            <p>See our glowing reviews on</p>
                            <img src="https://upload.wikimedia.org/wikipedia/commons/a/a0/G2_Logo.png"
                                style="height:20px; filter:brightness(0) invert(1);">
                            <img src="https://upload.wikimedia.org/wikipedia/commons/3/3a/Capterra_logo.png"
                                style="height:20px; filter:brightness(0) invert(1); margin-left:10px;">
                        </div> -->
                    </div>

                    <!-- 2. QUICK LINKS -->
                    <div class="footer-col">
                        <h6 class="footer-title"><i class="bi bi-list-ul"></i>Quick Links</h6>
                        <ul class="footer-links">
                            <li><i class="bi bi-circle-half"></i><a href="../index.php">Home</a></li>
                            <li><i class="bi bi-circle-half"></i><a class="nav-link"
                                    href="./starserver-about.php">About</a></li>
                            <li><i class="bi bi-circle-half"></i><a href="../page/starserver-services.php">Services</a>
                            </li>
                            <li><i class="bi bi-circle-half"></i><a
                                    href="../support/starserver-support.php">Supports</a></li>
                            <li><i class="bi bi-circle-half"></i><a href="../blog/starserver-blogs.php">Blogs</a></li>
                            <li><i class="bi bi-circle-half"></i><a href="../page/starserver-tools-&-add-ons.php">Tools
                                    & Add-Ons</a></li>
                            <li><i class="bi bi-circle-half"></i><a href="../page/starserver-contact.php">Contact</a>
                            </li>
                        </ul>
                    </div>

                    <!-- 3. SERVICES -->
                    <div class="footer-col">
                        <h6 class="footer-title"><i class="bi bi-hdd-network"></i>Services</h6>
                        <ul class="footer-links">
                            <li><i class="bi bi-circle-half"></i><a
                                    href="../page/starserver-single-domain-hosting.php">Single Domain Hosting</a></li>
                            <li><i class="bi bi-circle-half"></i><a
                                    href="../page/starserver-double-domain-plan.php">Double Domain Plan</a></li>
                            <li><i class="bi bi-circle-half"></i><a href="../page/starserver-five-domain-plan.php">5
                                    Domain Plan</a></li>
                            <li><i class="bi bi-circle-half"></i><a href="../page/starserver-ten-domain-plan.php">10
                                    Domain Plan</a></li>
                            <li><i class="bi bi-circle-half"></i><a href="../page/starserver-twenty-domains-plan.php">20
                                    Domains Plan</a></li>
                            <li><i class="bi bi-circle-half"></i><a
                                    href="../page/starserver-unlimited-domain-plan.php">Unlimited Domain Plan</a></li>
                        </ul>
                    </div>

                    <!-- 4. BLOGS -->
                    <div class="footer-col">
                        <h6 class="footer-title">
                            <i class="bi bi-journal-text"></i> Blogs
                        </h6>
                        <ul class="footer-links">
                            <li><i class="bi bi-circle-half"></i><a
                                    href="../blog/starserver-affordable-cpanel-hosting-india.php">Affordable cPanel
                                    Hosting</a></li>
                            <li><i class="bi bi-circle-half"></i><a href="../blog/starserver-launch-website.php">Website
                                    Launch Guide</a></li>
                        </ul>
                    </div>

                    <!-- 5. CONTACT INFO -->
                    <div class="footer-col">
                        <h6 class="footer-title"><i class="bi bi-chat-dots"></i>Contact Info</h6>
                        <ul class="contact-list">

                            <li><i class="bi bi-telephone"></i> +91 9432807919</li>
                            <li><i class="bi bi-envelope"></i> info@starserver.in</li>
                            <li><i class="bi bi-envelope"></i> helpdesk@starserver.in</li>
                            <li><i class="bi bi-clock"></i> 24/7 Technical Support</li>
                        </ul>
                    </div>

                </div>

                <!-- FOOTER BOTTOM (UNCHANGED) -->
                <div class="footer-bottom">
                    <div class="copyright-left">
                        Copyright © 2026 STAR SERVER. All Rights Reserved.
                    </div>
                    <div class="copyright-right">
                        <a href="../legal-&-trust/starserver-terms-&-conditions.php">Terms & Conditions</a>
                        <a href="../legal-&-trust/starserver-privacy-policy.php">Privacy Policy</a>
                        <a href="../legal-&-trust/starserver-refund-&-cancellation-policy.php">Refund & Cancellation
                            Policy</a>
                        <a href="../legal-&-trust/starserver-fair-usage-policy.php">Fair Usage Policy</a>
                    </div>
                </div>

            </div>
        </footer>
        <!-- footer exit -->

    </div>
    <!-- Back to Top Button Floating Button-->
    <button id="et-top-btn" aria-label="Back to top">
        <span class="et-top-arrow">↑</span>
    </button>
    <!-- WhatsApp Floating Button-->
    <a href="https://wa.me/919432807919" class="whatsapp-float" target="_blank" aria-label="Chat on WhatsApp">
        <i class="bi bi-whatsapp"></i>
    </a>

    <!-- Call Floating Button (Mobile Only) -->
    <a href="tel:+919432807919" class="call-float" aria-label="Call Us">
        <i class="bi bi-telephone-fill"></i>
    </a>


    <!-- ================= JS SECTION ================= -->

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- AOS -->
    <script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>

    <!-- Font Awesome -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/js/all.min.js"></script>

    <script>
        AOS.init();
    </script>


    <script>
        const navbar = document.querySelector('.navbar');
        const navbarOffset = navbar.offsetTop;

        window.addEventListener('scroll', () => {
            if (window.pageYOffset > navbarOffset) {
                navbar.classList.add('fixed');
            } else {
                navbar.classList.remove('fixed');
            }
        });
    </script>



    <!-- Back to top -->
    <script>
        (() => {
            const btn = document.getElementById('et-top-btn');

            window.addEventListener('scroll', () => {
                if (window.scrollY > 300) {
                    btn.classList.add('et-show');
                } else {
                    btn.classList.remove('et-show');
                }
            });

            btn.addEventListener('click', () => {
                window.scrollTo({
                    top: 0,
                    behavior: 'smooth'
                });
            });
        })();
    </script>



</body>

</html>