<?php
require_once __DIR__ . '/../database/dbconfig.php';

/* FETCH CATEGORIES */
$categories = [];
$query = "SELECT cat_id, cat_name FROM categories WHERE cat_status='Active' ORDER BY cat_name ASC";
$result = mysqli_query($con, $query);
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $categories[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?= $page_title ?? 'Mithu Library'; ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Bootstrap -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

<!-- Favicon -->
<link rel="icon" href="images/logo/mithu_library_fav.jpg">

<style>
/* ===== TOP HEADER ===== */
.top-header{
    font-size:13px;
    padding:4px 0;
    background:#6E1F0E;
}

/* ===== STICKY HEADER ===== */
.header-wrapper{
    position:sticky;
    top:0;
    z-index:1000;
}

/* ===== NAVBAR ===== */
.navbar-brand img{
    height:48px;
}
.navbar-nav .nav-link {
    color: #000000 !important;
    font-weight: 500;
    padding: 8px 16px;
    transition: color 0.3s ease;
    font-size: 17px;
    margin: 10px;
}

@media (max-width:991px) {
    .navbar-nav .nav-link {
    color: #ffffff !important;
    font-weight: 500;
    padding: 8px 16px;
    transition: color 0.3s ease;
    font-size: 17px;
    margin: 10px;
}
}
/* ===== MEGA MENU ===== */
.dropdown-menu.mega-menu{
    width:650px;
    left:50%!important;
    transform:translateX(-50%);
    background: #6E1F0E;
    border:none;
    border-radius:14px;
}
.dropdown-menu.mega-menu a{
    color:#fff;
    font-size:14px;
    padding:6px 10px;
}
.dropdown-menu.mega-menu a:hover{
    background:rgba(255,255,255,.15);
    border-radius:6px;
}

/* ===== OFFCANVAS ===== */
.offcanvas{
    width:280px;
}
.offcanvas .nav-link{
    padding:10px 0;
    font-size:16px;
}
.offcanvas-body {
    background-color: #004e51 !important;
}
/* ===== MOBILE ===== */
@media(max-width:991px){
    .dropdown-menu.mega-menu{
        width:100%;
        left:0!important;
        transform:none;
    }
}
.admin-btn {
    background: #FDBA21 !important;
    color:#000;
    border:2px solid #FDBA21;
    
}
@media (max-width:991px) {
    .social {
        display:none;
    }
}
</style>
</head>

<body>

<div class="header-wrapper">

<!-- ===== TOP HEADER ===== -->
<div class="top-header  text-light">
    <div class="container d-flex justify-content-between align-items-center">
        <div>
            <i class="bi bi-telephone"></i> +91 6913100780 |
            <i class="bi bi-envelope"></i> mithulibrary@gmail.com |
            <i class="fa fa-user text-warning"></i> Mithu Library
        </div>
        <div class="social">
            <a href="#" class="text-light me-2"><i class="bi bi-facebook"></i></a>
            <a href="#" class="text-light"><i class="bi bi-instagram"></i></a>
        </div>
    </div>
</div>

<!-- ===== NAVBAR ===== -->
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
<div class="container">

    <!-- LOGO -->
    <a class="navbar-brand" href="index.php">
        <img src="./images/logo/mithu_library_logo.jpg" alt="Mithu Library">
    </a>

    <!-- OFFCANVAS TOGGLER -->
    <button class="navbar-toggler" type="button"
            data-bs-toggle="offcanvas" data-bs-target="#mobileMenu">
        <span class="navbar-toggler-icon"></span>
    </button>

    <!-- DESKTOP MENU -->
    <div class="collapse navbar-collapse d-none d-lg-flex">
        <ul class="navbar-nav ms-auto align-items-center">

            <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
            <li class="nav-item"><a class="nav-link" href="about.php">About Us</a></li>

            <!-- MEGA MENU -->
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                    Class wise Course Details
                </a>

                <div class="dropdown-menu mega-menu p-4">
                    <div class="row">
                        <?php foreach(array_chunk($categories, ceil(count($categories)/3)) as $col): ?>
                        <div class="col-md-4">
                            <?php foreach($col as $cat): ?>
                            <a class="dropdown-item"
                               href="category_posts.php?cat=<?= $cat['cat_id']; ?>">
                                <?= htmlspecialchars($cat['cat_name']); ?>
                            </a>
                            <?php endforeach; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </li>

            <li class="nav-item"><a class="nav-link" href="contact.php">Contact Us</a></li>
        </ul>

        <a href="adminlogin.php" class="btn btn-warning ms-3">Admin Login</a>
    </div>
</div>
</nav>

</div>

<!-- ===== OFFCANVAS MOBILE MENU ===== -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="mobileMenu">
<div class="offcanvas-header">
    <h5>Mithu Library</h5>
    <button class="btn-close" data-bs-dismiss="offcanvas"></button>
</div>

<div class="offcanvas-body">
    <ul class="navbar-nav">

        <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="about.php">About Author</a></li>

        <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                Class wise Course Details
            </a>
            <ul class="dropdown-menu">
                <?php foreach($categories as $cat): ?>
                <li>
                    <a class="dropdown-item"
                       href="category_posts.php?cat=<?= $cat['cat_id']; ?>">
                        <?= htmlspecialchars($cat['cat_name']); ?>
                    </a>
                </li>
                <?php endforeach; ?>
            </ul>
        </li>

        <li class="nav-item"><a class="nav-link" href="contact.php">Contact Us</a></li>

        <a href="adminlogin.php" class="btn  w-100 mt-3 admin-btn">
            Admin Login
        </a>
    </ul>
</div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
