/* =========================
   AOS INIT
========================= */
document.addEventListener("DOMContentLoaded", () => {
    if (window.AOS) {
        AOS.init();
    }
});


/* =========================
   TOGGLE STATS
========================= */
function toggleStats() {
    const stats = document.getElementById("statsGrid");
    if (stats) stats.classList.toggle("hidden");
}


/* =========================
   BOOTSTRAP CAROUSEL
========================= */
document.addEventListener("DOMContentLoaded", () => {
    const carouselEl = document.querySelector("#carouselExampleCaptions");
    if (carouselEl && window.bootstrap) {
        new bootstrap.Carousel(carouselEl, {
            interval: 2000,
            ride: "carousel"
        });
    }
});


/* =========================
   PAGE LOADER
========================= */
window.addEventListener("load", () => {
    const loader = document.getElementById("loader");
    if (loader) loader.style.display = "none";
});



/* =========================
   STAT COUNTER (ON VIEW)
========================= */
document.addEventListener("DOMContentLoaded", () => {
    const counters = document.querySelectorAll(".stat-number");
    const section = document.querySelector(".stats-section");
    let started = false;

    if (!section) return;

    const startCounter = () => {
        counters.forEach(counter => {
            counter.innerText = "0";
            const target = +counter.dataset.target;
            const increment = target / 200;

            const update = () => {
                const current = +counter.innerText;
                if (current < target) {
                    counter.innerText = Math.ceil(current + increment);
                    setTimeout(update, 20);
                } else {
                    counter.innerText = target.toLocaleString();
                }
            };
            update();
        });
    };

    const observer = new IntersectionObserver(entries => {
        if (entries[0].isIntersecting && !started) {
            startCounter();
            started = true;
        }
    });

    observer.observe(section);
});


/* =========================
   BACK TO TOP BUTTON
========================= */
window.addEventListener("scroll", () => {
    const btn = document.getElementById("backToTop");
    if (btn) {
        btn.style.display = window.scrollY > 200 ? "block" : "none";
    }
});

document.getElementById("backToTop")?.addEventListener("click", () => {
    window.scrollTo({ top: 0, behavior: "smooth" });
});


/* =========================
   LOGO CAROUSEL (INFINITE)
========================= */
document.addEventListener("DOMContentLoaded", () => {
    const track = document.querySelector(".carousel-track");
    if (!track) return;

    [...track.children].forEach(card => {
        track.appendChild(card.cloneNode(true));
    });
});


/* =========================
   NAVBAR DROPDOWN (RESPONSIVE)
========================= */
document.addEventListener("DOMContentLoaded", () => {
    const dropdowns = document.querySelectorAll(".navbar .dropdown");

    const clearMenus = () => {
        dropdowns.forEach(d => {
            d.classList.remove("show");
            d.querySelector(".dropdown-menu")?.classList.remove("show");
        });
    };

    const desktopMode = () => {
        dropdowns.forEach(drop => {
            drop.onmouseenter = () => {
                drop.classList.add("show");
                drop.querySelector(".dropdown-menu")?.classList.add("show");
            };
            drop.onmouseleave = () => clearMenus();
        });
    };

    const mobileMode = () => {
        dropdowns.forEach(drop => {
            drop.onclick = e => {
                e.stopPropagation();
                clearMenus();
                drop.classList.toggle("show");
                drop.querySelector(".dropdown-menu")?.classList.toggle("show");
            };
        });
        document.onclick = clearMenus;
    };

    const handleResize = () => {
        clearMenus();
        dropdowns.forEach(d => (d.onclick = d.onmouseenter = d.onmouseleave = null));
        window.innerWidth > 991 ? desktopMode() : mobileMode();
    };

    handleResize();
    window.addEventListener("resize", handleResize);
});


/* =========================
   BEFORE-AFTER COMPARISON SLIDER
========================= */
document.addEventListener("DOMContentLoaded", () => {
    const container = document.getElementById("comparisonContainer");
    const before = document.getElementById("beforeWrapper");
    const handle = document.getElementById("sliderHandle");

    if (!container || !before || !handle) return;

    let dragging = false;

    const move = x => {
        const rect = container.getBoundingClientRect();
        const offset = Math.max(0, Math.min(x - rect.left, rect.width));
        const percent = (offset / rect.width) * 100;
        before.style.width = percent + "%";
        handle.style.left = percent + "%";
    };

    handle.addEventListener("mousedown", () => (dragging = true));
    window.addEventListener("mouseup", () => (dragging = false));
    window.addEventListener("mousemove", e => dragging && move(e.clientX));

    handle.addEventListener("touchstart", () => (dragging = true));
    window.addEventListener("touchend", () => (dragging = false));
    window.addEventListener("touchmove", e => dragging && move(e.touches[0].clientX));
});


/* =========================
   REVEAL CARDS ON SCROLL
========================= */
document.addEventListener("DOMContentLoaded", () => {
    const revealCards = document.querySelectorAll(".choose-card");

    revealCards.forEach(card => {
        card.style.opacity = "0";
        card.style.transform = "translateY(30px)";
        card.style.transition = "all 0.8s ease";
    });

    const reveal = () => {
        const trigger = window.innerHeight * 0.85;
        revealCards.forEach(card => {
            if (card.getBoundingClientRect().top < trigger) {
                card.style.opacity = "1";
                card.style.transform = "translateY(0)";
            }
        });
    };

    window.addEventListener("scroll", reveal);
    reveal();
});

// SAP Course
function showCategory(index) {
    const buttons = document.querySelectorAll('.category-list .list-group-item');
    const contents = document.querySelectorAll('.category-box');

    buttons.forEach(btn => btn.classList.remove('active'));
    contents.forEach(content => content.classList.remove('active'));

    buttons[index].classList.add('active');
    contents[index].classList.add('active');
}

// scripts
function showSection(sectionId) {
    const sections = document.querySelectorAll('.section');
    sections.forEach(section => {
        section.classList.remove('active-section');
    });

    document.getElementById(sectionId).classList.add('active-section');

    const menuItems = document.querySelectorAll('.sidebar ul li');
    menuItems.forEach(item => item.classList.remove('active'));
    event.target.classList.add('active');
}

function showSection(sectionId) {
    document.querySelectorAll('.section').forEach(section => {
        section.classList.remove('active-section');
        section.style.display = 'none';
    });

    document.getElementById(sectionId).style.display = 'block';
    document.getElementById(sectionId).classList.add('active-section');
}
// dropdown

function toggleDropdown(element) {
    element.parentElement.classList.toggle("active");
}


// logout
function confirmLogout() {
    return confirm("Are you sure you want to logout?");
}
// add post

function addImageSection() {
    const section = document.createElement('div');
    section.className = 'card mb-3';
    section.innerHTML = `
        <div class="card-body">
            <h6 class="mb-2">Image Section</h6>
            <input type="file" class="form-control mb-2">
            <button type="button" class="btn btn-sm btn-danger" onclick="this.closest('.card').remove()">
                Remove
            </button>
        </div>
    `;
    document.getElementById('dynamicSections').appendChild(section);
}

function addContentSection() {
    const section = document.createElement('div');
    section.className = 'card mb-3';
    section.innerHTML = `
        <div class="card-body">
            <h6 class="mb-2">Content Section</h6>
            <textarea class="form-control mb-2" rows="4" placeholder="Enter content..."></textarea>
            <button type="button" class="btn btn-sm btn-danger" onclick="this.closest('.card').remove()">
                Remove
            </button>
        </div>
    `;
    document.getElementById('dynamicSections').appendChild(section);
}

function addPostSection() {
    const section = document.createElement('div');
    section.className = 'card mb-3 border-primary';
    section.innerHTML = `
        <div class="card-body">
            <h6 class="mb-2">Post Block</h6>

            <input type="text" class="form-control mb-2" placeholder="Section Title">

            <textarea class="form-control mb-2" rows="4" placeholder="Section content..."></textarea>

            <button type="button" class="btn btn-sm btn-danger" onclick="this.closest('.card').remove()">
                Remove
            </button>
        </div>
    `;
    document.getElementById('dynamicSections').appendChild(section);
}

// add catagory 
function togglePDF() {
    document.getElementById('pdfSection').classList.toggle('d-none');
}

// pdf sell
function addPdfSell() {
    const div = document.createElement('div');
    div.className = 'card mb-3 border-danger';

    div.innerHTML = `
        <div class="card-body">
            <h6 class="mb-3 text-danger">
                <i class="bi bi-file-earmark-pdf"></i> PDF Sell Section
            </h6>

            <!-- PDF Title -->
            <div class="mb-2">
                <label class="form-label">PDF Title</label>
                <input type="text" class="form-control" placeholder="Enter PDF title">
            </div>

            <!-- PDF Price -->
            <div class="mb-2">
                <label class="form-label">Price (₹)</label>
                <input type="number" class="form-control" placeholder="Enter price">
            </div>

            <!-- PDF Description -->
            <div class="mb-2">
                <label class="form-label">Short Description</label>
                <textarea class="form-control" rows="3" placeholder="PDF details..."></textarea>
            </div>

            <!-- PDF Upload -->
            <div class="mb-3">
                <label class="form-label">Upload PDF</label>
                <input type="file" class="form-control" accept="application/pdf">
            </div>

            <!-- Remove Button -->
            <button type="button" class="btn btn-sm btn-outline-danger" onclick="this.closest('.card').remove()">
                <i class="bi bi-trash"></i> Remove PDF
            </button>
        </div>
    `;

    document.getElementById('pdfSellContainer').appendChild(div);
}


// image featured
let sectionIndex = 0;

function addImageSection() {
    sectionIndex++;
    document.getElementById('dynamicSections').insertAdjacentHTML('beforeend', `
        <div class="border rounded p-3 mb-3">
            <input type="hidden" name="sections[${sectionIndex}][type]" value="image">
            <label>Image</label>
            <input type="file" name="sections[${sectionIndex}][file]" class="form-control">
        </div>
    `);
}

function addContentSection() {
    sectionIndex++;
    document.getElementById('dynamicSections').insertAdjacentHTML('beforeend', `
        <div class="border rounded p-3 mb-3">
            <input type="hidden" name="sections[${sectionIndex}][type]" value="content">
            <label>Content</label>
            <textarea name="sections[${sectionIndex}][text]" class="form-control" rows="4"></textarea>
        </div>
    `);
}

function addPostSection() {
    sectionIndex++;
    document.getElementById('dynamicSections').insertAdjacentHTML('beforeend', `
        <div class="border rounded p-3 mb-3">
            <input type="hidden" name="sections[${sectionIndex}][type]" value="block">
            <input type="text" name="sections[${sectionIndex}][title]" class="form-control mb-2" placeholder="Block Title">
            <textarea name="sections[${sectionIndex}][content]" class="form-control" rows="4" placeholder="Block Content"></textarea>
        </div>
    `);
}


// add pdf and video


// text editor
  tinymce.init({
    selector: '#post_content',
    height: 400,
    menubar: true,
    plugins: [
      'advlist autolink lists link image charmap preview anchor',
      'searchreplace visualblocks code fullscreen',
      'insertdatetime media table paste help wordcount'
    ],
    toolbar: 'undo redo | formatselect | ' +
      'bold italic backcolor | alignleft aligncenter ' +
      'alignright alignjustify | bullist numlist outdent indent | ' +
      'removeformat | help',
    content_style: 'body { font-family:Arial,sans-serif; font-size:14px }'
  });














