<?php
include(__DIR__ . '/../includes/db.php');
include(__DIR__ . '/../includes/header.php');
include(__DIR__ . '/../includes/admin_navbar.php');

/* Fetch only pending approvals */
$query = mysqli_query($conn, "
    SELECT * FROM hosting_plans
    WHERE payment_status = 'pending'
    ORDER BY created_at DESC
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Pending Approvals</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    background:#f4f6fb;
    font-family:Inter, sans-serif;
}
.page-title{
    font-size:18px;
    font-weight:600;
}
.card-box{
    background:#fff;
    border-radius:14px;
    padding:18px;
    box-shadow:0 10px 20px rgba(0,0,0,.08);
}
.table th{
    font-size:13px;
    color:#555;
}
.table td{
    font-size:13px;
}
.badge-pending{
    background:#fff3cd;
    color:#856404;
    padding:5px 12px;
    border-radius:20px;
    font-size:11px;
    font-weight:600;
}
.btn-view{
    background:#4f46e5;
    color:#fff;
    font-size:11px;
    padding:5px 10px;
    border-radius:6px;
    text-decoration:none;
}
.btn-view:hover{color:#fff;}
</style>
</head>

<body>

<div class="container my-4">

<div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="page-title">Pending Payment Approvals</h3>
    <span class="badge bg-warning text-dark">
        <?= mysqli_num_rows($query); ?> Pending
    </span>
</div>

<div class="card-box table-responsive">

<table class="table align-middle">
<thead>
<tr>
    <th>#</th>
    <th>User</th>
    <th>Email</th>
    <th>Plan</th>
    <th>Domain</th>
    <th>Amount</th>
    <th>Requested On</th>
    <th>Status</th>
    <th>Action</th>
</tr>
</thead>

<tbody>
<?php
if(mysqli_num_rows($query) > 0){
    $i = 1;
    while($row = mysqli_fetch_assoc($query)){
?>
<tr>
<td><?= $i++; ?></td>
<td><?= htmlspecialchars($row['fullname']); ?></td>
<td><?= htmlspecialchars($row['email']); ?></td>
<td><?= htmlspecialchars($row['plan_name']); ?></td>
<td><?= htmlspecialchars($row['domain_name']); ?></td>
<td>₹<?= htmlspecialchars($row['amount']); ?></td>
<td><?= date('d M Y, h:i A', strtotime($row['created_at'])); ?></td>
<td>
    <span class="badge-pending">PENDING</span>
</td>
<td>
    <a href="view_user.php?id=<?= (int)$row['id']; ?>" class="btn-view">
        View & Approve
    </a>
</td>
</tr>
<?php }} else { ?>
<tr>
<td colspan="9" class="text-center text-muted py-4">
    No pending approvals 🎉
</td>
</tr>
<?php } ?>
</tbody>
</table>

</div>
</div>

</body>
</html>

<?php include(__DIR__ . '/../includes/footer.php'); ?>
